<?php

namespace App\Restify\Invitations\Controllers;

use App\Models\Invitation;
use App\Models\User;
use Binaryk\LaravelRestify\Http\Requests\RestifyRequest;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

class ConfirmInvitation
{
    public function __invoke(RestifyRequest $request): JsonResponse
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'token' => ['required', 'string', 'exists:invitations,token'],
            'password' => ['required', 'confirmed', Password::defaults()],
        ]);

        $invitation = Invitation::with('role')
            ->where('token', $request->input('token'))
            ->firstOrFail();

        abort_if($invitation->isValidated(), 422, 'Invitation already confirmed.');

        abort_if($invitation->isCancelled(), 422, 'Invitation has been cancelled.');

        $user = User::create([
            'name' => $request->input('name'),
            'email' => $invitation->email,
            'password' => Hash::make($request->input('password')),
        ]);

        $user->assignRole($invitation->role);

        $invitation->update(['user_id' => $user->id]);
        $invitation->validate();

        return ok('Invitation confirmed successfully.', 201);
    }
}
