<?php

namespace App\Restify\Invitations\Actions;

use App\Models\Invitation;
use Binaryk\LaravelRestify\Actions\Action;
use Binaryk\LaravelRestify\Http\Requests\ActionRequest;
use Illuminate\Http\JsonResponse;

class CancelInvitationRestifyAction extends Action
{
    public static $uriKey = 'cancel-invitation-email';

    public function handle(ActionRequest $request, Invitation $invitation): JsonResponse
    {
        if ($invitation->isCancelled()) {
            return response()->json([
                'message' => 'Invitation already cancelled.',
            ], 422);
        }

        if ($invitation->isValidated()) {
            return response()->json([
                'message' => 'Invitation already validated.',
            ], 422);
        }

        $invitation->cancel();

        return ok();
    }
}
