<?php

namespace App\Policies;

use App\Models\Invitation;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class InvitationPolicy
{
    use HandlesAuthorization;

    public function allowRestify(User $user): bool
    {
        return true;
    }

    public function show(User $user, Invitation $invitation): bool
    {
        return true;
    }

    public function store(User $user): bool
    {
        return true;
    }

    public function storeBulk(User $user): bool
    {
        return $user->isAdmin();
    }

    public function update(User $user, Invitation $invitation): bool
    {
        return $user->id === $invitation->user_id || $user->isAdmin();
    }

    public function updateBulk(User $user, Invitation $invitation): bool
    {
        return $user->isAdmin();
    }

    public function deleteBulk(User $user, Invitation $invitation): bool
    {
        return $user->isAdmin();
    }

    public function delete(User $user, Invitation $invitation): bool
    {
        return $user->id === $invitation->user_id || $user->isAdmin();
    }
}
