<?php

namespace App\Models\Concerns;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Auth;

trait WithCreator
{
    protected static function bootWithCreator(): void
    {
        static::updating(function (Model $model) {
            if (is_null(Auth::id())) {
                return true;
            }

            $model->setAttribute('updated_by', Auth::id());
        });

        static::creating(function (Model $model) {
            if (is_null(Auth::id())) {
                return true;
            }

            $model->setAttribute('updated_by', Auth::id());
            $model->setAttribute('created_by', Auth::id());
        });
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function editor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
