<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Laravel Restify Starter Kit - Installation Guide</title>

    <!-- Favicon -->
    <link rel="icon" href="/favicon.svg" type="image/svg+xml">
    <link rel="apple-touch-icon" href="/apple-touch-icon.png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700&display=swap" rel="stylesheet"/>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="min-h-screen bg-white dark:bg-zinc-900">
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <!-- Header -->
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white mb-4">
            Laravel Restify Starter Kit
        </h1>
        <p class="text-lg text-gray-600 dark:text-gray-400">
            Complete installation guide for your Laravel API project
        </p>
    </div>

    <!-- Quick Info -->
    <div class="bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-800 rounded-lg p-4 mb-8">
        <div class="flex items-start gap-3">
            <svg class="w-5 h-5 text-emerald-600 dark:text-emerald-400 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
            </svg>
            <div>
                <h3 class="font-semibold text-emerald-900 dark:text-emerald-400">Ready to use starter kit</h3>
                <p class="text-sm text-emerald-800 dark:text-emerald-300 mt-1">
                    This starter kit includes authentication, user management, teams, roles & permissions, and invitations system out of the box.
                </p>
            </div>
        </div>
    </div>

    <!-- Requirements -->
    <div class="mb-8">
        <h2 class="text-2xl font-semibold text-gray-900 dark:text-white mb-4">Requirements</h2>
        <div class="space-y-2">
            <div class="flex items-center gap-2">
                <span class="text-emerald-500">✓</span>
                <span class="text-gray-700 dark:text-gray-300">PHP ^8.2</span>
            </div>
            <div class="flex items-center gap-2">
                <span class="text-emerald-500">✓</span>
                <span class="text-gray-700 dark:text-gray-300">Laravel ^12.0</span>
            </div>
            <div class="flex items-center gap-2">
                <span class="text-emerald-500">✓</span>
                <span class="text-gray-700 dark:text-gray-300">Composer 2.x</span>
            </div>
            <div class="flex items-center gap-2">
                <span class="text-emerald-500">✓</span>
                <span class="text-gray-700 dark:text-gray-300">MySQL/PostgreSQL/SQLite</span>
            </div>
        </div>
    </div>

    <!-- Installation Steps -->
    <div class="space-y-8">
        <h2 class="text-2xl font-semibold text-gray-900 dark:text-white">Installation Steps</h2>

        <!-- Step 1 -->
        <div class="space-y-4">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                <span class="flex items-center justify-center w-8 h-8 bg-emerald-500 text-white rounded-full text-sm font-bold">1</span>
                Install Dependencies
            </h3>
            <p class="text-gray-700 dark:text-gray-300">
                Install PHP dependencies using Composer:
            </p>
            <div class="bg-gray-900 rounded-lg p-4 overflow-x-auto">
                <code class="text-sm text-gray-100">
                    composer install
                </code>
            </div>
        </div>

        <!-- Step 2 -->
        <div class="space-y-4">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                <span class="flex items-center justify-center w-8 h-8 bg-emerald-500 text-white rounded-full text-sm font-bold">2</span>
                Environment Setup
            </h3>
            <p class="text-gray-700 dark:text-gray-300">
                Copy the example environment file and generate an application key:
            </p>
            <div class="bg-gray-900 rounded-lg p-4 overflow-x-auto space-y-2">
                <div><code class="text-sm text-gray-100">cp .env.example .env</code></div>
                <div><code class="text-sm text-gray-100">php artisan key:generate</code></div>
            </div>
        </div>

        <!-- Step 3 -->
        <div class="space-y-4">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                <span class="flex items-center justify-center w-8 h-8 bg-emerald-500 text-white rounded-full text-sm font-bold">3</span>
                Configure Database
            </h3>
            <p class="text-gray-700 dark:text-gray-300">
                Update your <code class="bg-gray-200 dark:bg-gray-800 px-2 py-1 rounded text-sm">.env</code> file with your database credentials:
            </p>
            <div class="bg-gray-900 rounded-lg p-4 overflow-x-auto">
                    <pre class="text-sm text-gray-100">DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_database_name
DB_USERNAME=your_username
DB_PASSWORD=your_password</pre>
            </div>
        </div>

        <!-- Step 4 -->
        <div class="space-y-4">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                <span class="flex items-center justify-center w-8 h-8 bg-emerald-500 text-white rounded-full text-sm font-bold">4</span>
                Run Migrations
            </h3>
            <p class="text-gray-700 dark:text-gray-300">
                Create the database tables:
            </p>
            <div class="bg-gray-900 rounded-lg p-4 overflow-x-auto">
                <code class="text-sm text-gray-100">
                    php artisan migrate
                </code>
            </div>
        </div>

        <!-- Step 5 -->
        <div class="space-y-4">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                <span class="flex items-center justify-center w-8 h-8 bg-emerald-500 text-white rounded-full text-sm font-bold">5</span>
                Seed Initial Data (Optional)
            </h3>
            <p class="text-gray-700 dark:text-gray-300">
                Optionally, seed the database with sample data:
            </p>
            <div class="bg-gray-900 rounded-lg p-4 overflow-x-auto">
                <code class="text-sm text-gray-100">
                    php artisan db:seed
                </code>
            </div>
        </div>

        <!-- Step 6 -->
        <div class="space-y-4">
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white flex items-center gap-3">
                <span class="flex items-center justify-center w-8 h-8 bg-emerald-500 text-white rounded-full text-sm font-bold">6</span>
                Start the Development Server
            </h3>
            <p class="text-gray-700 dark:text-gray-300">
                You can now start the Laravel development server using either command:
            </p>
            <div class="bg-gray-900 rounded-lg p-4 overflow-x-auto">
                <div><code class="text-sm text-gray-100">composer dev</code> <span class="text-gray-400 text-xs ml-2"># Recommended - runs php artisan serve</span></div>
                <div><code class="text-sm text-gray-100">php artisan serve</code></div>
            </div>
            <p class="text-gray-700 dark:text-gray-300 mt-2">
                Your API will be available at <code class="bg-gray-200 dark:bg-gray-800 px-2 py-1 rounded text-sm">http://127.0.0.1:8000</code>
            </p>
        </div>
    </div>

    <!-- API Endpoints -->
    <div class="mt-12 space-y-4">
        <h2 class="text-2xl font-semibold text-gray-900 dark:text-white">Available API Endpoints</h2>
        <p class="text-gray-700 dark:text-gray-300">
            After installation, the following endpoints will be available:
        </p>

        <div class="bg-gray-50 dark:bg-gray-800 rounded-lg p-6 space-y-6">
            <!-- Authentication -->
            <div>
                <h4 class="font-semibold text-gray-900 dark:text-white mb-2">Authentication</h4>
                <div class="space-y-1 text-sm font-mono">
                    <div class="text-gray-600 dark:text-gray-400">POST /api/register</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/login</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/forgotPassword</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/resetPassword</div>
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/profile</div>
                    <div class="text-gray-600 dark:text-gray-400">PUT /api/restify/profile</div>
                </div>
            </div>

            <!-- User Management -->
            <div>
                <h4 class="font-semibold text-gray-900 dark:text-white mb-2">User Management</h4>
                <div class="space-y-1 text-sm font-mono">
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/users</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/users</div>
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/users/{id}</div>
                    <div class="text-gray-600 dark:text-gray-400">PATCH /api/restify/users/{id}</div>
                    <div class="text-gray-600 dark:text-gray-400">DELETE /api/restify/users/{id}</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/users/{id}/sync/roles</div>
                </div>
            </div>

            <!-- Roles & Permissions -->
            <div>
                <h4 class="font-semibold text-gray-900 dark:text-white mb-2">Roles & Permissions</h4>
                <div class="space-y-1 text-sm font-mono">
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/roles</div>
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/roles/{id}</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/roles</div>
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/permissions</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/roles/{id}/sync/permissions</div>
                </div>
            </div>

            <!-- Teams Management -->
            <div>
                <h4 class="font-semibold text-gray-900 dark:text-white mb-2">Teams Management</h4>
                <div class="space-y-1 text-sm font-mono">
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/teams</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/teams</div>
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/teams/{id}</div>
                    <div class="text-gray-600 dark:text-gray-400">DELETE /api/restify/teams/{id}</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/teams/bulk</div>
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/teams/{id}/users</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/teams/{id}/attach/users</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/teams/{id}/detach/users</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/teams/{id}/sync/users</div>
                </div>
            </div>

            <!-- Invitations -->
            <div>
                <h4 class="font-semibold text-gray-900 dark:text-white mb-2">Invitations</h4>
                <div class="space-y-1 text-sm font-mono">
                    <div class="text-gray-600 dark:text-gray-400">GET /api/restify/invitations</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/invitations</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/invitations/{id}/actions?action=resend-invitation-email</div>
                    <div class="text-gray-600 dark:text-gray-400">POST /api/restify/invitations/confirm</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Postman Collection -->
    <div class="mt-12 bg-purple-50 dark:bg-purple-900/20 border border-purple-200 dark:border-purple-800 rounded-lg p-6">
        <h3 class="text-lg font-semibold text-purple-900 dark:text-purple-400 mb-4">Postman Collection</h3>
        <p class="text-purple-800 dark:text-purple-300 mb-4">
            The starter kit includes a complete Postman collection with all API endpoints pre-configured. You'll find it in the <code class="bg-purple-200 dark:bg-purple-800 px-2 py-1 rounded text-sm">storage/postman</code> folder.
        </p>

        <div class="space-y-4">
            <div>
                <h4 class="font-semibold text-purple-900 dark:text-purple-400 mb-2">Using with Laravel Valet or Herd</h4>
                <p class="text-purple-800 dark:text-purple-300 mb-2">
                    If you're using Laravel Valet or Laravel Herd, you can easily configure the Postman collection:
                </p>
                <ol class="list-decimal list-inside space-y-2 text-purple-800 dark:text-purple-300">
                    <li>Import the collection and environment files from <code class="bg-purple-200 dark:bg-purple-800 px-1 rounded text-sm">storage/postman</code></li>
                    <li>Go to Postman Environments</li>
                    <li>Edit the <code class="bg-purple-200 dark:bg-purple-800 px-1 rounded text-sm">api</code> variable</li>
                    <li>Replace it with your folder name (e.g., <code class="bg-purple-200 dark:bg-purple-800 px-1 rounded text-sm">http://laravel-restify-starter-kit.test/api</code>)</li>
                </ol>
            </div>

            <div>
                <h4 class="font-semibold text-purple-900 dark:text-purple-400 mb-2">Default Configuration</h4>
                <p class="text-purple-800 dark:text-purple-300">
                    By default, the Postman environment is configured for <code class="bg-purple-200 dark:bg-purple-800 px-1 rounded text-sm">http://127.0.0.1:8000/api</code>
                </p>
            </div>
        </div>
    </div>

    <!-- Project Structure -->
    <div class="mt-12 space-y-4">
        <h2 class="text-2xl font-semibold text-gray-900 dark:text-white">Project Structure</h2>
        <p class="text-gray-700 dark:text-gray-300">
            This is a standard Laravel application with minimal modifications. The main addition is the <code class="bg-gray-200 dark:bg-gray-800 px-2 py-1 rounded text-sm">app/Restify</code> folder where all Laravel Restify repositories are located.
        </p>

        <div class="bg-gray-50 dark:bg-gray-800 rounded-lg p-6">
            <h3 class="font-semibold text-gray-900 dark:text-white mb-4">Key Directories</h3>
            <pre class="text-sm text-gray-600 dark:text-gray-400 overflow-x-auto">app/
├── Restify/                    # Laravel Restify repositories
│   ├── Users/
│   │   ├── UserRepository.php  # User model wrapper
│   │   └── Actions/           # Custom user actions
│   ├── TeamRepository.php      # Team model wrapper
│   ├── Permissions/
│   │   ├── PermissionRepository.php
│   │   ├── RoleRepository.php
│   │   └── Actions/           # Permission-related actions
│   └── Invitations/
│       ├── InvitationRepository.php
│       ├── Actions/           # Invitation actions
│       └── Controllers/       # Custom controllers
├── Models/                     # Standard Laravel models
├── Http/Controllers/           # Standard Laravel controllers
├── Policies/                   # Laravel policies
└── Providers/                  # Service providers</pre>
        </div>

        <div class="grid md:grid-cols-3 gap-6 mt-8">
            <div class="bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-800 rounded-lg p-4">
                <h4 class="font-semibold text-emerald-900 dark:text-emerald-400 mb-2">Repositories</h4>
                <p class="text-sm text-emerald-800 dark:text-emerald-300 mb-3">
                    Model wrappers that define how your models are exposed via the API. Each repository corresponds to a model.
                </p>
                <a href="https://restify.binarcode.com/api/repositories" target="_blank" class="text-sm text-emerald-700 dark:text-emerald-400 hover:underline">
                    Learn more →
                </a>
            </div>

            <div class="bg-purple-50 dark:bg-purple-900/20 border border-purple-200 dark:border-purple-800 rounded-lg p-4">
                <h4 class="font-semibold text-purple-900 dark:text-purple-400 mb-2">Actions</h4>
                <p class="text-sm text-purple-800 dark:text-purple-300 mb-3">
                    Custom actions that can be performed on resources. Located in Actions folders within each repository.
                </p>
                <a href="https://restify.binarcode.com/api/actions" target="_blank" class="text-sm text-purple-700 dark:text-purple-400 hover:underline">
                    Learn more →
                </a>
            </div>

            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                <h4 class="font-semibold text-blue-900 dark:text-blue-400 mb-2">Fields</h4>
                <p class="text-sm text-blue-800 dark:text-blue-300 mb-3">
                    Each repository defines fields that represent model attributes and control data display/validation.
                </p>
                <a href="https://restify.binarcode.com/api/fields" target="_blank" class="text-sm text-blue-700 dark:text-blue-400 hover:underline">
                    Learn more →
                </a>
            </div>
        </div>

        <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-6 mt-6">
            <h4 class="font-semibold text-yellow-900 dark:text-yellow-400 mb-2">Getting Started with Development</h4>
            <ol class="list-decimal list-inside space-y-2 text-yellow-800 dark:text-yellow-300">
                <li><strong>Explore existing repositories</strong>: Start by opening <code class="bg-yellow-200 dark:bg-yellow-800 px-1 rounded text-sm">app/Restify/Users/UserRepository.php</code> to see how fields are defined</li>
                <li><strong>Add new fields</strong>: Each field typically represents a model attribute</li>
                <li><strong>Create custom actions</strong>: Add new actions in the Actions folder when you need custom endpoints</li>
                <li><strong>Standard Laravel</strong>: Everything else follows standard Laravel conventions - models, migrations, controllers, etc.</li>
            </ol>
        </div>
    </div>

    <!-- Next Steps -->
    <div class="mt-12 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-6">
        <h3 class="text-lg font-semibold text-blue-900 dark:text-blue-400 mb-2">Next Steps</h3>
        <ul class="space-y-2 text-blue-800 dark:text-blue-300">
            <li class="flex items-start gap-2">
                <span class="text-blue-600 dark:text-blue-400 mt-1">•</span>
                <span>Import and explore the Postman collection to test all endpoints</span>
            </li>
            <li class="flex items-start gap-2">
                <span class="text-blue-600 dark:text-blue-400 mt-1">•</span>
                <span>Customize the authentication and user models to fit your needs</span>
            </li>
            <li class="flex items-start gap-2">
                <span class="text-blue-600 dark:text-blue-400 mt-1">•</span>
                <span>Set up your preferred queue driver for background jobs</span>
            </li>
            <li class="flex items-start gap-2">
                <span class="text-blue-600 dark:text-blue-400 mt-1">•</span>
                <span>Configure mail settings for email notifications</span>
            </li>
        </ul>
    </div>

    <!-- Support -->
    <div class="mt-12 text-center">
        <p class="text-gray-600 dark:text-gray-400 mb-4">
            Need help? Check out the full documentation or reach out to our community.
        </p>
        <div class="flex justify-center gap-4">
            <a href="https://restify.binarcode.com" target="_blank" class="inline-flex items-center gap-2 px-4 py-2 bg-emerald-500 hover:bg-emerald-600 text-white rounded-lg transition-colors">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                </svg>
                Full Documentation
            </a>
            <a href="https://github.com/BinarCode/laravel-restify" target="_blank" class="inline-flex items-center gap-2 px-4 py-2 bg-gray-700 hover:bg-gray-800 text-white rounded-lg transition-colors">
                <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z"/>
                </svg>
                GitHub
            </a>
        </div>
    </div>
</div>
</body>
</html>
