<?php

namespace App\Restify\Users\Actions;

use App\Models\User;
use Binaryk\LaravelRestify\Actions\Action;
use Binaryk\LaravelRestify\Http\Requests\RestifyRequest;
use Illuminate\Http\JsonResponse;
use Spatie\Permission\Models\Role;

class AttachRoleFieldAction extends Action
{
    public function handle(RestifyRequest $request, User $user): JsonResponse
    {
        abort_unless($request->user()->isAdmin(), 403, 'You are not allowed to perform this action.');

        $role = Role::findByName($request->input('role'));

        $user->assignRole($role);

        return ok();
    }
}
