<?php

namespace App\Restify;

use App\Models\Team;
use App\Restify\Users\UserRepository;
use Binaryk\LaravelRestify\Fields\BelongsToMany;
use Binaryk\LaravelRestify\Http\Requests\RestifyRequest;

class TeamRepository extends Repository
{
    public static string $model = Team::class;

    public static function related(): array
    {
        return [
            BelongsToMany::make('users', UserRepository::class),
        ];
    }

    public function fields(RestifyRequest $request): array
    {
        return [
            id(),

            field('name')->storingRules('required', 'string', 'max:255'),

            field('description'),
        ];
    }
}
