<?php

namespace App\Restify\Invitations;

use App\Models\Invitation;
use App\Restify\Invitations\Actions\CancelInvitationRestifyAction;
use App\Restify\Invitations\Actions\ResendInvitationEmailRestifyAction;
use App\Restify\Invitations\Controllers\ConfirmInvitation;
use App\Restify\Permissions\RoleRepository;
use App\Restify\Repository;
use App\Restify\Users\UserRepository;
use Binaryk\LaravelRestify\Fields\BelongsTo;
use Binaryk\LaravelRestify\Http\Requests\RestifyRequest;
use Illuminate\Routing\Router;
use Spatie\Permission\Models\Role;

class InvitationRepository extends Repository
{
    public static string $model = Invitation::class;

    public static array $match = [
        'user_id' => 'int',
        'email' => 'string',
        'role_id' => 'int',
    ];

    public static function related(): array
    {
        return [
            BelongsTo::make('user', UserRepository::class),
            BelongsTo::make('role', RoleRepository::class),
        ];
    }

    public function fields(RestifyRequest $request): array
    {
        return [
            id(),

            field('email')->rules(['required', 'email', 'unique:invitations,email']),

            field('role')
                ->rules('required', 'exists:roles,name')
                ->fillCallback(function (RestifyRequest $request, Invitation $model) {
                    $model->role_id = Role::findByName($request->input('role'))?->id;
                })
                ->resolveCallback(fn () => $this->role?->name),

            field('validated_at')->readonly(),
        ];
    }

    public function actions(RestifyRequest $request): array
    {
        return [
            CancelInvitationRestifyAction::make()->onlyOnShow(),
            ResendInvitationEmailRestifyAction::make()->onlyOnShow(),
        ];
    }

    public static function routes(Router $router, array $attributes, $wrap = true): void
    {
        $router
            ->post('confirm', [ConfirmInvitation::class, '__invoke'])
            ->withoutMiddleware('auth:sanctum');
    }
}
