<?php

namespace App\Restify\Invitations\Actions;

use App\Models\Invitation;
use Binaryk\LaravelRestify\Actions\Action;
use Binaryk\LaravelRestify\Http\Requests\ActionRequest;
use Illuminate\Http\JsonResponse;

class ResendInvitationEmailRestifyAction extends Action
{
    public static $uriKey = 'resend-invitation-email';

    public function handle(ActionRequest $request, Invitation $invitation): JsonResponse
    {
        if ($invitation->isValidated()) {
            return response()->json([
                'message' => 'Invitation already validated.',
            ], 422);
        }

        if ($invitation->isCancelled()) {
            $invitation->reactivate();
        }

        $invitation->sendInvitationEmail();

        return ok();
    }
}
