<?php

namespace App\Providers;

use App\Models\Team;
use App\Models\User;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        MorphTo::morphMap([
            'user' => User::class,
            'team' => Team::class,
        ]);

        $this->macros();
    }

    private function macros(): void
    {
        Blueprint::macro('creator', function () {
            /** @var Blueprint $table */
            $table = $this;
            $table->foreignUlid('created_by')->nullable();
            $table->foreignUlid('updated_by')->nullable();
        });
    }
}
