<?php

namespace App\Policies;

use App\Enums\Permissions;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class UserPolicy
{
    use HandlesAuthorization;

    public function allowRestify(User $user): bool
    {
        return true;
    }

    public function show(User $user, User $model): bool
    {
        return true;
    }

    public function store(User $user): bool
    {
        return $user->can(Permissions::manageUsers->value);
    }

    public function storeBulk(User $user): bool
    {
        return $user->can(Permissions::manageUsers->value);
    }

    public function update(User $user, User $model): bool
    {
        return $user->id === $model->id || $user->can(Permissions::manageUsers->value);
    }

    public function updateBulk(User $user, User $model): bool
    {
        return $user->can(Permissions::manageUsers->value);
    }

    public function deleteBulk(User $user, User $model): bool
    {
        return $user->can(Permissions::manageUsers->value);
    }

    public function delete(User $user, User $model): bool
    {
        return $user->can(Permissions::manageUsers->value);
    }

    public function syncRoles(User $user, User $model): bool
    {
        return $user->can(Permissions::manageUsers->value) &&
            $user->can(Permissions::managePermissions->value);
    }
}
