<?php

namespace App\Policies;

use App\Enums\Permissions;
use App\Models\Team;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class TeamPolicy
{
    use HandlesAuthorization;

    public function allowRestify(User $user): bool
    {
        return true;
    }

    public function show(User $user, Team $team): bool
    {
        return true;
    }

    public function store(User $user): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }

    public function storeBulk(User $user): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }

    public function update(User $user, Team $team): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }

    public function updateBulk(User $user, Team $team): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }

    public function deleteBulk(User $user, Team $team): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }

    public function delete(User $user, Team $team): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }

    public function attachUsers(User $user, Team $team): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }

    public function detachUsers(User $user, Team $team): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }

    public function syncUsers(User $user, Team $team): bool
    {
        return $user->can(Permissions::manageTeams->value);
    }
}
