<?php

namespace App\Policies;

use App\Enums\Permissions;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Spatie\Permission\Models\Role;

class RolePolicy
{
    use HandlesAuthorization;

    public function allowRestify(User $user): bool
    {
        return true;
    }

    public function show(User $user, Role $role): bool
    {
        return true;
    }

    public function store(User $user): bool
    {
        return $user->can(Permissions::managePermissions->value);
    }

    public function storeBulk(User $user): bool
    {
        return $user->can(Permissions::managePermissions->value);
    }

    public function update(User $user, Role $role): bool
    {
        return $user->can(Permissions::managePermissions->value);
    }

    public function updateBulk(User $user, Role $role): bool
    {
        return $user->can(Permissions::managePermissions->value);
    }

    public function deleteBulk(User $user, Role $role): bool
    {
        return $user->can(Permissions::managePermissions->value);
    }

    public function delete(User $user, Role $role): bool
    {
        return $user->can(Permissions::managePermissions->value);
    }

    public function syncPermissions(User $user, Role $role): bool
    {
        return $user->can(Permissions::managePermissions->value);
    }
}
