# Laravel Restify API Starter

A powerful, production-ready Laravel API starter kit built with [Laravel Restify](https://restify.binarcode.com/), offering a complete authentication system, roles & permissions, teams management, users management, invitations system, and more.

## 📋 Prerequisites

For an easy setup, you'll need:

1. **PHP 8.2+** and **Composer** installed
2. **MySQL** database server running
3. A database created for the application
4. **Laravel Herd** (recommended) - [https://herd.laravel.com/](https://herd.laravel.com/) for exposing the app locally

> **Note:** The Postman collection is pre-configured to use `http://127.0.0.1:8000/api`. You can run the app with `composer dev` (which runs `php artisan serve`), but ensure your MySQL server is running and a database is created first.

## 🔧 Installation

```bash
# Clone the repository
unzip restify-kit.zip

# Navigate to the project directory
cd restify-kit.test

# Install dependencies
composer install

# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate

# Configure your database in .env file
# Then run migrations
php artisan migrate

# Seed the database with initial data (optional)
php artisan db:seed

# Start the development server
php artisan serve
```

## 🚀 Features

### Authentication System
Complete authentication system with:
- User registration
- Login with JWT/Sanctum
- Password reset flow
- Profile management
- Secure by default

**Endpoints:**
```
POST   /api/login                     # Login with email/password
POST   /api/register                  # Register new user
POST   /api/forgotPassword            # Request password reset
POST   /api/resetPassword             # Reset password with token
GET    /api/restify/profile           # Get authenticated user profile
PUT    /api/restify/profile           # Update authenticated user profile
```

### Roles & Permissions
Built with Spatie's permissions package for fine-grained access control:
- Create and manage roles
- Assign permissions to roles
- Assign roles to users
- Sync permissions for roles
- API endpoints for complete management

**Endpoints:**
```
GET    /api/restify/roles             # List all roles
GET    /api/restify/roles/{id}        # Show specific role
POST   /api/restify/roles             # Create new role (with optional permissions)
GET    /api/restify/permissions       # List all available permissions
POST   /api/restify/roles/{id}/sync/permissions  # Sync permissions for role
POST   /api/restify/users/{id}/sync/roles        # Sync roles to user
```

### Teams Management
Complete team functionality with:
- Team creation and management
- Bulk team creation
- Member management (attach/detach/sync)
- Paginated team members
- Related data loading

**Endpoints:**
```
GET    /api/restify/teams             # List all teams
GET    /api/restify/teams/{id}        # Show team (with optional relations)
POST   /api/restify/teams             # Create new team
POST   /api/restify/teams/bulk       # Bulk create teams
DELETE /api/restify/teams/{id}        # Delete team
GET    /api/restify/teams/{id}/users  # Paginate team members
POST   /api/restify/teams/{id}/attach/users   # Attach users to team
POST   /api/restify/teams/{id}/detach/users   # Detach users from team
POST   /api/restify/teams/{id}/sync/users     # Sync team users
```

### Users Management
Comprehensive user management with:
- Complete CRUD operations
- Filtering and sorting
- Relationship management
- Role assignments

**Endpoints:**
```
GET    /api/restify/users             # List all users
POST   /api/restify/users             # Create new user (with role)
GET    /api/restify/users/{id}        # Show specific user
PATCH  /api/restify/users/{id}        # Update user partially
DELETE /api/restify/users/{id}        # Delete user
```

### Invitations System
Invite new users with a complete workflow:
- Send invitations with role assignment
- Track invitation status
- Resend invitation emails
- Confirm invitations

**Endpoints:**
```
GET    /api/restify/invitations       # List all invitations
POST   /api/restify/invitations       # Create invitation with role
POST   /api/restify/invitations/{id}/actions?action=resend-invitation-email  # Resend email
POST   /api/restify/invitations/confirm  # Confirm invitation (no auth required)
```

### Postman Collection
Get started instantly with:
- Ready-to-import collection file
- Environment variables pre-configured
- Authentication flows set up
- Example requests for all endpoints
- Organized by feature categories

## 📁 Project Structure

This is a standard Laravel application with minimal modifications. The main addition is the `app/Restify` folder where all Laravel Restify repositories are located.

### Key Directories

```
app/
├── Restify/                    # Laravel Restify repositories
│   ├── Users/
│   │   ├── UserRepository.php  # User model wrapper
│   │   └── Actions/           # Custom user actions
│   │       └── AttachRoleFieldAction.php
│   ├── TeamRepository.php      # Team model wrapper
│   ├── Permissions/
│   │   ├── PermissionRepository.php
│   │   ├── RoleRepository.php
│   │   └── Actions/           # Permission-related actions
│   └── Invitations/
│       ├── InvitationRepository.php
│       ├── Actions/           # Invitation actions
│       └── Controllers/       # Custom controllers
├── Models/                     # Standard Laravel models
├── Http/Controllers/           # Standard Laravel controllers
├── Policies/                   # Laravel policies
└── Providers/                  # Service providers
```

### Understanding Laravel Restify Structure

**Repositories** (`app/Restify/*Repository.php`)
- These are model wrappers that define how your models are exposed via the API
- Each repository corresponds to a model (e.g., `UserRepository` wraps the `User` model)
- Learn more: [https://restify.binarcode.com/api/repositories](https://restify.binarcode.com/api/repositories)

**Actions** (`app/Restify/*/Actions/`)
- Custom actions that can be performed on resources
- Located in `Actions` folders within each repository's directory
- Learn more: [https://restify.binarcode.com/api/actions](https://restify.binarcode.com/api/actions)

**Fields**
- Each repository defines fields that represent model attributes
- Fields control how data is displayed, validated, and stored
- Check `app/Restify/Users/UserRepository.php` to see examples
- Learn more: [https://restify.binarcode.com/api/fields](https://restify.binarcode.com/api/fields)

### Getting Started with Development

1. **Explore existing repositories**: Start by opening `app/Restify/Users/UserRepository.php` to see how fields are defined
2. **Add new fields**: Each field typically represents a model attribute
3. **Create custom actions**: Add new actions in the `Actions` folder when you need custom endpoints
4. **Standard Laravel**: Everything else follows standard Laravel conventions - models, migrations, controllers, etc.

## 📞 Support

If you encounter any problems or have any questions, please open an issue on GitHub or contact us at hello@binarcode.com

---

Made with ❤️ by [Eduard/BinarCode](https://binarcode.com)
