<?php

namespace Database\Seeders;

use App\Models\Team;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $admin = User::factory()->create([
            'email' => 'admin@restifytemplates.com',
            'password' => Hash::make('password'),
        ]);

        $admin->assignRole('admin');

        $user = User::factory()->create([
            'email' => 'user@restifytemplates.com',
            'password' => Hash::make('password'),
        ]);

        User::factory()->create([
            'email' => 'guest@restifytemplates.com',
            'password' => Hash::make('password'),
        ]);

        $user->assignRole('user');

        $team = Team::first();

        $admin->teams()->attach($team);
        $user->teams()->attach($team);
    }
}
