<?php

namespace Database\Seeders;

use App\Enums\Permissions;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        // Create permissions using enum values
        foreach (Permissions::cases() as $permission) {
            Permission::create([
                'name' => $permission->value,
                'guard_name' => 'sanctum',
            ]);
        }

        // Create roles with sanctum guard and assign permissions
        $admin = Role::create([
            'name' => 'admin',
            'guard_name' => 'sanctum',
        ]);

        $user = Role::create([
            'name' => 'user',
            'guard_name' => 'sanctum',
        ]);

        Role::create([
            'name' => 'guest',
            'guard_name' => 'sanctum',
        ]);

        // Admin gets all permissions
        $admin->givePermissionTo(array_map(fn ($p) => $p->value, Permissions::cases()));

        // User gets limited permissions
        $user->givePermissionTo([
            Permissions::manageTeams->value,
        ]);
    }
}
