<?php

namespace App\Restify\Permissions;

use App\Restify\Permissions\Actions\AttachRolePermissionsFieldAction;
use App\Restify\Repository;
use Binaryk\LaravelRestify\Fields\BelongsToMany;
use Binaryk\LaravelRestify\Http\Requests\RestifyRequest;
use Spatie\Permission\Models\Role;

class RoleRepository extends Repository
{
    public static string $model = Role::class;

    public static function related(): array
    {
        return [
            BelongsToMany::make('permissions', PermissionRepository::class),
        ];
    }

    public function fields(RestifyRequest $request): array
    {
        return [
            id(),

            field('name')->storingRules('required', 'string', 'max:255'),

            field('permissions')
                ->hidden()
                ->action(app(AttachRolePermissionsFieldAction::class)),
        ];
    }
}
