<?php

namespace App\Restify\Permissions\Actions;

use Binaryk\LaravelRestify\Actions\Action;
use Binaryk\LaravelRestify\Http\Requests\RestifyRequest;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Spatie\Permission\Models\Role;

class AttachRolePermissionsFieldAction extends Action
{
    public function handle(RestifyRequest $request, Role $role): JsonResponse
    {
        Gate::authorize('syncPermissions', $role);

        $role->syncPermissions($request->input('permissions', []));

        return ok();
    }
}
